package com.wissamfawaz;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

import org.json.JSONArray;
import org.json.JSONObject;

public class Main {
    public static void main(String[] args) throws Exception {
        URL url = new URL("https://jsonplaceholder.typicode.com/posts");
        HttpURLConnection connection = (HttpURLConnection) url.openConnection();

        int code = connection.getResponseCode();
        if (code == HttpURLConnection.HTTP_OK) {
            StringBuilder response = new StringBuilder();

            BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));

            String line;
            while ((line = br.readLine()) != null) {
                response.append(line);
            }

            JSONArray posts = new JSONArray(response.toString());
            System.out.println("# of posts: " + posts.length());
            System.out.println("Titles: ");
            for (int idx = 0; idx < posts.length(); idx++) {
                JSONObject post = posts.getJSONObject(idx);
                System.out.println(post.getString("title"));
            }

        } else {
            System.out.println("Failed to establish connection: " + code);
        }
    }
}
